// dashboard_signals.def
// ---------------------
// MAPPINGS(name, offset, scale)
DASHBOARD_MAPPING(distance_m,           0.0, 0.01)
DASHBOARD_MAPPING(velicity_ms,          0.0, 0.01)
DASHBOARD_MAPPING(soc_percent,          0.0, 0.1)
DASHBOARD_MAPPING(current_A,            0.0, 0.01)
DASHBOARD_MAPPING(motor_pwm,            0.0, 1.0)


// SIGNALS(id, displayLabel, mappingName)
DASHBOARD_SIGNAL(SIG_Z,                "Altitude (m)",              distance_m)
DASHBOARD_SIGNAL(SIG_X,                "X (m)",                     distance_m)
DASHBOARD_SIGNAL(SIG_Y,                "Y (m)",     	            distance_m)
DASHBOARD_SIGNAL(SIG_VZ,               "Climb rate (m/s)",          velicity_ms)
DASHBOARD_SIGNAL(SIG_VX,               "Velocity X (m/s)",          velicity_ms)
DASHBOARD_SIGNAL(SIG_VY,               "Velocity Y (m/s)",          velicity_ms)
DASHBOARD_SIGNAL(SIG_COMMAND_VZ,       "Command climb rate (m/s)",  velicity_ms)
DASHBOARD_SIGNAL(SIG_COMMAND_VX,       "Command velocity X (m/s)",  velicity_ms)
DASHBOARD_SIGNAL(SIG_COMMAND_VY,       "Command velocity Y (m/s)",  velicity_ms)
DASHBOARD_SIGNAL(SIG_SOC,              "Battery SoC %",             soc_percent)
DASHBOARD_SIGNAL(SIG_IBAT,             "Battery current (A)",       soc_percent)
DASHBOARD_SIGNAL(SIG_M1PWM,            "Motor 1 PWM",               motor_pwm)
DASHBOARD_SIGNAL(SIG_M2PWM,            "Motor 2 PWM",               motor_pwm)
DASHBOARD_SIGNAL(SIG_M3PWM,            "Motor 3 PWM",               motor_pwm)
DASHBOARD_SIGNAL(SIG_M4PWM,            "Motor 4 PWM",               motor_pwm)


// ----- STATES -----
// A group contains named states (e.g., DRIVE: STOP/GO/PAUSE)
DASHBOARD_STATE_GROUP(MODE,               "Flight Mode")
DASHBOARD_STATE      (MODE, IDLE,         "Idle")
DASHBOARD_STATE      (MODE, PREFLIGHT,    "Pre-flight")
DASHBOARD_STATE      (MODE, TAKEOFF,      "Take off")
DASHBOARD_STATE      (MODE, CRUISE,       "Cruise")
DASHBOARD_STATE      (MODE, LANDING,      "Landing")
DASHBOARD_STATE      (MODE, DONE,         "Done")


// ----- ERRORS -----
DASHBOARD_ERROR(E_OVERTEMP,     1, "Over temperature")
DASHBOARD_ERROR(E_OVERCURRENT,  2, "Over current")
DASHBOARD_ERROR(E_UNDERVOLT,    3, "Under voltage")
// ----- ERRORS -----
DASHBOARD_ERROR(E_OVERTEMP,     1, "Over temperature")
DASHBOARD_ERROR(E_OVERCURRENT,  2, "Over current")
DASHBOARD_ERROR(E_UNDERVOLT,    3, "Under voltage")
