// dashboard_signals.def
// ---------------------
// MAPPINGS(name, offset, scale)
DASHBOARD_MAPPING(distance_m,           0.0, 0.01)
DASHBOARD_MAPPING(velicity_ms,          0.0, 0.01)


// SIGNALS(id, displayLabel, mappingName)
DASHBOARD_SIGNAL(SIG_Z,                "Altitude (m)",              distance_m)
DASHBOARD_SIGNAL(SIG_X,                "X (m)",                     distance_m)
DASHBOARD_SIGNAL(SIG_Y,                "Y (m)",     	            distance_m)
DASHBOARD_SIGNAL(SIG_VZ,               "Climb rate (m/s)",          velicity_ms)
DASHBOARD_SIGNAL(SIG_VX,               "Velocity X (m/s)",          velicity_ms)
DASHBOARD_SIGNAL(SIG_VY,               "Velocity Y (m/s)",          velicity_ms)
DASHBOARD_SIGNAL(SIG_COMMAND_VZ,       "Command climb rate (m/s)",  velicity_ms)
DASHBOARD_SIGNAL(SIG_COMMAND_VX,       "Command velocity X (m/s)",  velicity_ms)
DASHBOARD_SIGNAL(SIG_COMMAND_VY,       "Command velocity Y (m/s)",  velicity_ms)


// ----- STATES -----
// A group contains named states (e.g., DRIVE: STOP/GO/PAUSE)
DASHBOARD_STATE_GROUP(DRIVE, "Drive State")
DASHBOARD_STATE      (DRIVE, STOP,  "Stop")
DASHBOARD_STATE      (DRIVE, GO,    "Go")
DASHBOARD_STATE      (DRIVE, PAUSE, "Pause")

DASHBOARD_STATE_GROUP(GEAR, "Gear")
DASHBOARD_STATE      (GEAR, OUT, "Out of gear")
DASHBOARD_STATE      (GEAR, IN,  "In gear")


// ----- ERRORS -----
DASHBOARD_ERROR(E_OVERTEMP,     1, "Over temperature")
DASHBOARD_ERROR(E_OVERCURRENT,  2, "Over current")
DASHBOARD_ERROR(E_UNDERVOLT,    3, "Under voltage")
