// dashboard_signals.def
// ---------------------
// MAPPINGS(name, offset, scale)
DASHBOARD_MAPPING(distance_m, 0.0, 0.01)
DASHBOARD_MAPPING(voltage_V,            0.0, 0.01)
DASHBOARD_MAPPING(rpm,                  0.0, 0.1)
DASHBOARD_MAPPING(fuel,                 0.0, 0.1)

// SIGNALS(id, displayLabel, mappingName)
DASHBOARD_SIGNAL(SIG_Z,                "Altitude (m)",              distance_m)
DASHBOARD_SIGNAL(SIG_X,                "X (m)",                     distance_m)
DASHBOARD_SIGNAL(SIG_Y,                "Y (m)",     	            distance_m)
DASHBOARD_SIGNAL(SIG_MOTOR_RPM,        "Motor RPM (1/s)",           rpm)
DASHBOARD_SIGNAL(SIG_ALTERNATOR_RPM,   "Alternator RPM (1/s)",      rpm)
DASHBOARD_SIGNAL(SIG_FUEL_LEVEL,       "Fuel level (Litres)",       fuel)

// ----- STATES -----
// A group contains named states (e.g., DRIVE: STOP/GO/PAUSE)
DASHBOARD_STATE_GROUP(DRIVE, "Drive State")
DASHBOARD_STATE      (DRIVE, STOP,  "Stop")
DASHBOARD_STATE      (DRIVE, GO,    "Go")
DASHBOARD_STATE      (DRIVE, PAUSE, "Pause")

DASHBOARD_STATE_GROUP(GEAR, "Gear")
DASHBOARD_STATE      (GEAR, OUT, "Out of gear")
DASHBOARD_STATE      (GEAR, IN,  "In gear")


// ----- ERRORS -----
DASHBOARD_ERROR(E_OVERTEMP,     1, "Over temperature")
DASHBOARD_ERROR(E_OVERCURRENT,  2, "Over current")
DASHBOARD_ERROR(E_UNDERVOLT,    3, "Under voltage")
